<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class BaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $roles = json_decode(File::get(storage_path('app/parametrosBD/roles.json')), true);
        DB::table('roles')->insert($roles);

        $tiposDocumento = json_decode(File::get(storage_path('app/parametrosBD/tiposDocumento.json')), true);
        DB::table('tipos_documento')->insert($tiposDocumento);

        $estadosVisita = json_decode(File::get(storage_path('app/parametrosBD/estadosVisita.json')), true);
        DB::table('estados_visita')->insert($estadosVisita);

        $departamentos = json_decode(File::get(storage_path('app/parametrosBD/departamentos.json')), true);
        DB::table('departamentos')->insert($departamentos);

        $municipios = json_decode(File::get(storage_path('app/parametrosBD/municipios.json')), true);
        DB::table('municipios')->insert($municipios);

        $gruposServicio = json_decode(File::get(storage_path('app/parametrosBD/gruposServicio.json')), true);
        DB::table('grupos_servicio')->insert($gruposServicio);
    }
}