<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigInteger('id');
            $table->integer('cli_fk_id');
            $table->integer('rol_fk_id');
            $table->string('usu_cargo', 500)->nullable();
            $table->string('usu_verificacion', 6)->nullable();
            $table->smallInteger('usu_intentos_verificacion')->default(0);
            $table->string('usu_codigo_bloqueo', 500)->nullable();
            $table->string('usu_autorizacion_codigo_bloqueo', 50)->nullable();
            $table->timestamp('usu_plazo_cambio_codigo_bloqueo')->nullable();
            $table->boolean('usu_mod_suh_3100')->default(false);
            $table->boolean('usu_mod_aud_calidad')->default(false);
            $table->boolean('usu_mod_rias')->default(false);
            $table->boolean('usu_mod_pamec')->default(false);

            $table->timestamps();

            $table->primary('id');
            $table->foreign('rol_fk_id')->references('rol_pk_id')->on('roles');

            $table->index('usu_autorizacion_codigo_bloqueo');
            $table->index(['cli_fk_id', 'rol_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
