<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reps_servicios', function (Blueprint $table) {
            $table->bigIncrements('rsr_pk_id');
            $table->string('rpr_fk_id', 50);
            $table->string('rps_fk_id', 50);

            $table->integer('grs_fk_id');

            $table->string('rsr_codigo_servicio', 50);
            $table->string('rsr_nombre_servicio', 1000);

            $table->boolean('rsr_3100_mod_intramural')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_extramural')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_unidad_movil')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_domiciliario')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_jornada_salud')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_telemedicina')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prestador_referencia')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prf_tme_interactiva')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prf_tme_no_interactiva')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prf_tele_experticia')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prf_tele_monitoreo')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_prestador_remisor')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_pre_tele_experticia')->default(false)->nullable();
            $table->boolean('rsr_3100_mod_pre_tele_monitoreo')->default(false)->nullable();

            $table->boolean('rsr_3100_complejidad_baja')->default(false)->nullable();
            $table->boolean('rsr_3100_complejidad_mediana')->default(false)->nullable();
            $table->boolean('rsr_3100_complejidad_alta')->default(false)->nullable();
            $table->boolean('rsr_3100_sin_complejidad')->default(false)->nullable();

            $table->boolean('rsr_3100_esp_oncologico')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_trasplante_osteomuscular')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_trasplante_piel')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_trasplante_cardiovascular')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_trasplante_tejido_ocular')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_atencion_paciente_quemado')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_spa')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_otras_patologias')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_tras_celulas_prog_hematopoyeticas')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_proc_quirurgicos_ambulatorios')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_rinon')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_higado')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_pancreas')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_intestino')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_multivisceral')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_corazon')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_organo_pulmon')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_sustancias_psicoactivas')->default(false)->nullable();
            $table->boolean('rsr_3100_esp_trasplante_renal')->default(false)->nullable();

            $table->boolean('rsr_activo')->default(true);

            $table->foreign('grs_fk_id')->references('grs_pk_id')->on('grupos_servicio');
            $table->foreign('rpr_fk_id')->references('rpr_pk_id')->on('reps_prestadores');
            $table->foreign('rps_fk_id')->references('rps_pk_id')->on('reps_prestadores_sedes');

            $table->index(['rpr_fk_id', 'rps_fk_id']);
            $table->index('rps_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reps_servicios');
    }
};
