<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

class PlanVisitasController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerPlanVisitasPorUsuario(Request $request, $ano, $mes, $idUsuario) {
        return DB::connection($this->cliente)->select("
            /* 1: RIAS */
            (select '1' || plv_pk_id as plv_pk_id, plv_ano, plv_mes, plv_fecha_visita, plv_comentario as plv_comentario, avr_visita_sincronizada as plv_visita_sincronizada,
                    avr_finalizada as plv_realizada, plv_fecha_cierre_visita, esv_fk_id, plv_comentario_cierre, avr_finalizada as plv_guardado_nube,
                    avr_responsable as plv_responsable, 1 as tvi_fk_id, 'RIAS' as tvi_descripcion, plv.rpr_fk_id, rpr_nit, rpr_razon_social, rpr_correo, rpr_direccion,
                    rpr_telefono, rps_fk_id, rps_nombre_sede, rps_correo, rps_direccion, rps_telefono, rps.dep_fk_id, dep.dep_nombre, rps.mun_fk_id, mun.mun_nombre,
                    plv_codigo_visita
            from auditores_visitas_rias as adv
            join plan_visitas_rias as plv on (adv.plv_fk_id = plv.plv_pk_id)
            join base.reps_prestadores as rpr on (plv.rpr_fk_id = rpr.rpr_pk_id)
            join base.reps_prestadores_sedes as rps on (plv.rps_fk_id = rps.rps_pk_id)
            join base.departamentos as dep on (dep.dep_pk_id = rps.dep_fk_id)
            join base.municipios as mun on (mun.mun_pk_id = rps.mun_fk_id)
            where plv_ano = ? and plv_mes = ? and plv_eliminada = false and usu_fk_id = ?)

            union all

            /* 2: CALIDAD */
            (select '2' || plv_pk_id as plv_pk_id, plv_ano, plv_mes, plv_fecha_visita, plv_comentario as plv_comentario, plv_visita_sincronizada, plv_realizada,
                    plv_fecha_cierre_visita, esv_fk_id, plv_comentario_cierre, plv_guardado_nube, true as plv_responsable, 2 as tvi_fk_id, 'CALIDAD' as tvi_descripcion,
                    plv.rpr_fk_id, rpr_nit, rpr_razon_social, rpr_correo, rpr_direccion, rpr_telefono, null as rps_fk_id, null as rps_nombre_sede, null as rps_correo,
                    null as rps_direccion, null as rps_telefono, rpr.dep_fk_id, dep.dep_nombre, rpr.mun_fk_id, mun.mun_nombre, null as plv_codigo_visita
            from plan_visitas_calidad as plv
            join base.reps_prestadores as rpr on (plv.rpr_fk_id = rpr.rpr_pk_id)
            join base.departamentos as dep on (dep.dep_pk_id = rpr.dep_fk_id)
            join base.municipios as mun on (mun.mun_pk_id = rpr.mun_fk_id)
            where plv_ano = ? and plv_mes = ? and plv_eliminada = false and usu_fk_id = ?)

            union all

            /* 3: PAMEC */
            (select '3' || plv_pk_id as plv_pk_id, plv_ano, plv_mes, plv_fecha_visita, plv_comentario as plv_comentario, plv_visita_sincronizada, plv_realizada,
                    plv_fecha_cierre_visita, esv_fk_id, plv_comentario_cierre, plv_guardado_nube, true as plv_responsable, 3 as tvi_fk_id, 'PAMEC' as tvi_descripcion,
                    plv.rpr_fk_id, rpr_nit, rpr_razon_social, rpr_correo, rpr_direccion, rpr_telefono, null as rps_fk_id, null as rps_nombre_sede, null as rps_correo,
                    null as rps_direccion, null as rps_telefono, rpr.dep_fk_id, dep.dep_nombre, rpr.mun_fk_id, mun.mun_nombre, null as plv_codigo_visita
            from plan_visitas_pamec as plv
            join base.reps_prestadores as rpr on (plv.rpr_fk_id = rpr.rpr_pk_id)
            join base.departamentos as dep on (dep.dep_pk_id = rpr.dep_fk_id)
            join base.municipios as mun on (mun.mun_pk_id = rpr.mun_fk_id)
            where plv_ano = ? and plv_mes = ? and plv_eliminada = false and usu_fk_id = ?)

            union all

            /* 4: SUH 3100 */
            (select '4' || plv_pk_id as plv_pk_id, plv_ano, plv_mes, plv_fecha_visita, plv_comentario as plv_comentario, avs_visita_sincronizada as plv_visita_sincronizada,
                    avs_finalizada as plv_realizada, plv_fecha_cierre_visita, esv_fk_id, plv_comentario_cierre, avs_finalizada as plv_guardado_nube,
                    avs_responsable as plv_responsable, 4 as tvi_fk_id, 'SUH 3100' as tvi_descripcion, plv.rpr_fk_id, rpr_nit, rpr_razon_social, rpr_correo, rpr_direccion,
                    rpr_telefono, rps_fk_id, rps_nombre_sede, rps_correo, rps_direccion, rps_telefono, rps.dep_fk_id, dep.dep_nombre, rps.mun_fk_id, mun.mun_nombre,
                    plv_codigo_visita
            from auditores_visitas_suh_3100 as ads
            join plan_visitas_suh_3100 as plv on (ads.plv_fk_id = plv.plv_pk_id)
            join base.reps_prestadores as rpr on (plv.rpr_fk_id = rpr.rpr_pk_id)
            join base.reps_prestadores_sedes as rps on (plv.rps_fk_id = rps.rps_pk_id)
            join base.departamentos as dep on (dep.dep_pk_id = rps.dep_fk_id)
            join base.municipios as mun on (mun.mun_pk_id = rps.mun_fk_id)
            where plv_ano = ? and plv_mes = ? and plv_eliminada = false and usu_fk_id = ?)
        ", [
            $ano, $mes, $idUsuario, // RIAS
            $ano, $mes, $idUsuario, // CALIDAD
            $ano, $mes, $idUsuario, // PAMEC
            $ano, $mes, $idUsuario // SUH 3100
        ]);
    }
}
