<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Services\DBClientConnection;

use App\Models\clientes\PlanVisitasCalidad;

class PlanVisitasCalidadController extends Controller
{
    private $cliente;

    function __construct() {
        // Crear la conexion temporal al esquema del cliente
        $this->middleware(function ($request, $next) {
            if (Auth::user() !== null) {
                $this->cliente = Auth::user()->cli_fk_id;
                $connection = new DBClientConnection();
                config(['database.connections.'.$this->cliente => $connection->getConnectionArray($this->cliente)]);
            }

            return $next($request);
        });
    }

    public function obtenerPlanVisitas(Request $request, $auditor, $ano, $mes) {
        return PlanVisitasCalidad::on($this->cliente)
                                 ->join('base.reps_prestadores', 'rpr_fk_id', 'rpr_pk_id')
                                 ->leftJoin('base.estados_visita', 'esv_fk_id', 'esv_pk_id')
                                 ->where('plv_ano', $ano)
                                 ->where('plv_mes', $mes)
                                 ->where('usu_fk_id', $auditor)
                                 ->where('plv_eliminada', false)
                                 ->orderBy('plv_fecha_visita', 'asc')
                                 ->get()->toArray();
    }

    public function buscarAsignacionPrestador(Request $request, $ano, $mes, $idPrestador) {
        return PlanVisitasCalidad::on($this->cliente)
                                 ->where('plv_ano', $ano)
                                 ->where('plv_mes', $mes)
                                 ->where('plv_eliminada', false)
                                 ->where('rpr_fk_id', $idPrestador)
                                 ->count();
    }

    public function crearPlanVisitas(Request $request) {
        DB::transaction(function() use($request) {
            $ano = $request->input('plv_ano');
            $mes = $request->input('plv_mes');
            $auditor = $request->input('auditor');
            $prestadoresAsignados = $request->input('prestadoresAsignados');

            foreach ($prestadoresAsignados as $rpr) {
                PlanVisitasCalidad::on($this->cliente)->create([
                    'plv_ano' => $ano,
                    'plv_mes' => $mes,
                    'usu_fk_id' => $auditor,
                    'rpr_fk_id' => $rpr['rpr_pk_id'],
                    'plv_comentario' => $rpr['plv_comentario'],
                    'plv_creada_por' => Auth::user()->id
                ]);
            }
        });
    }

    public function actualizarFechaVisita(Request $request, $idVisita) {
        PlanVisitasCalidad::on($this->cliente)
                          ->where('plv_pk_id', $idVisita)
                          ->update(['plv_fecha_visita' => $request->input('plv_fecha_visita')]);
    }

    public function actualizarSincronizacionVisita(Request $request, $idVisita) {
        PlanVisitasCalidad::on($this->cliente)->where('plv_pk_id', $idVisita)->update([
            'plv_visita_sincronizada' => $request->input('estado')
        ]);
    }

    /*public function eliminarPrestadorPlanVisitas(Request $request, $idVisita) {
        PlanVisitasCalidad::on($this->cliente)->where('plv_pk_id', $idVisita)
        ->update([
            'plv_eliminada' => true,
            'plv_borrada_por' => Auth::user()->id
        ]);
    }

    public function finalizarVisita(Request $request, $idVisita) {
        DB::transaction(function () use ($request, $idVisita) {
            PlanVisitasCalidad::on($this->cliente)->where('plv_pk_id', $idVisita)
            ->update([
                'plv_realizada' => true,
                'plv_fecha_cierre_visita' => 'now()',
                'esv_fk_id' => $request->input('esv_fk_id'),
                'plv_comentario_cierre' => $request->input('plv_comentario_cierre')
            ]);
        });
    }*/
}
