<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

use App\Http\Services\DBClientConnection;

use App\Models\base\Clientes;
use App\Http\Controllers\API\BoxController;

class ClientesController extends Controller
{
    /*public function obtenerClientes(Request $request) {
        return Clientes::selectRaw("clientes.*, dep_nombre, mun_nombre")
                       ->join('departamentos', 'dep_pk_id', 'dep_fk_id')
                       ->leftJoin('municipios', 'mun_pk_id', 'mun_fk_id')
                       ->orderBy('cli_razon_social')
                       ->get()->toArray();
    }

    public function obtenerClientesActivos(Request $request) {
        return Clientes::selectRaw("clientes.*, dep_nombre, mun_nombre")
                       ->join('departamentos', 'dep_pk_id', 'dep_fk_id')
                       ->leftJoin('municipios', 'mun_pk_id', 'clientes.mun_fk_id')
                       ->whereRaw('now()::date >= cli_fecha_inicio and now()::date <= cli_fecha_fin and cli_activo = true')
                       ->get()->toArray();
    }

    public function obtenerClientesInactivos(Request $request) {
        return Clientes::selectRaw("clientes.*, dep_nombre, mun_nombre")
                       ->join('departamentos', 'dep_pk_id', 'dep_fk_id')
                       ->leftJoin('municipios', 'mun_pk_id', 'mun_fk_id')
                       ->whereRaw('now()::date < cli_fecha_inicio or now()::date > cli_fecha_fin or cli_activo = false')
                       ->get()->toArray();
    }

    public function obtenerPersonalizacionEntidad(Request $request) {
        $cliente = Auth::user()->cli_fk_id;

        return Clientes::selectRaw("cli_razon_social, cli_doble_factor_auth, cli_logo_entidad")
                       ->where('cli_pk_id', $cliente)
                       ->get()->toArray();
    }

    public function obtenerServiciosCliente(Request $request) {
        $cliente = Auth::user()->cli_fk_id;

        return Clientes::selectRaw("cli_numero_usuarios, cli_almacenamiento_nube, cli_mod_suh_3100, cli_mod_aud_calidad, cli_mod_rias, cli_mod_pamec")
                       ->where('cli_pk_id', $cliente)
                       ->get()->toArray();
    }

    public function obtenerLogoEntidad(Request $request) {
        $idCliente = Auth::user()->cli_fk_id;
        $nombreLogo = Clientes::where('cli_pk_id', $idCliente)->pluck('cli_logo_entidad')[0];

        if ($nombreLogo !== null) {
            $imagePath = public_path("storage/logos/entidades/".$nombreLogo.".png");
        } else {
            $imagePath = public_path("storage/logos/entidades/logo-tguia-generico.png");
        }

        $headers = ['Content-Type' => 'image/png'];

        return response()->file($imagePath, $headers);
    }

    public function crearCliente(Request $request) {
        $datos = $request->all();
        $infoProceso = '';

        // Crear en nuevo cliente
        $id = Clientes::create(
            [
                'cli_razon_social' => $datos['cli_razon_social'],
                'cli_rep_legal' => $datos['cli_rep_legal'],
                'cli_email' => $datos['cli_email'],
                'dep_fk_id' => $datos['dep_fk_id'],
                'mun_fk_id' => $datos['mun_fk_id'],
                'cli_direccion' => $datos['cli_direccion'],
                'cli_fecha_inicio' => $datos['cli_fecha_inicio'],
                'cli_fecha_fin' => $datos['cli_fecha_fin'],
                'cli_numero_usuarios' => $datos['cli_numero_usuarios'],
                'cli_mod_suh_3100' => $datos['cli_mod_suh_3100'],
                'cli_mod_aud_calidad' => $datos['cli_mod_aud_calidad'],
                'cli_mod_rias' => $datos['cli_mod_rias'],
                'cli_mod_pamec' => $datos['cli_mod_pamec'],
                'cli_almacenamiento_nube' => $datos['cli_almacenamiento_nube']
            ]
        )->cli_pk_id;

        // Crear el esquema en la base de datos
        DB::statement('CREATE SCHEMA IF NOT EXISTS "'.$id.'"');

        $connection = new DBClientConnection();
        config(['database.connections.'.$id => $connection->getConnectionArray($id)]);

        // Migrar las tablas del esquema
        Artisan::call('migrate', ['--path' => 'database/migrations/clientes', '--database' => $id, '--force' => true]);
        Artisan::call('db:seed', ['--database' => $id, '--class' => 'ClientesSeeder', '--force' => true]);

        // Otras tareas
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_aud_calidad_con_urgencias start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_aud_calidad_sin_urgencias start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_aud_pamec_con_acreditacion start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_aud_pamec_sin_acreditacion start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_transversales start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_prim_infancia start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_infancia start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_adolescencia start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_juventud start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_adultez_hombres start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_adultez_mujeres start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_vejez_hombres start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_pym_vejez_mujeres start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atn_preconcepcional start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_ive start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_cuidado_prenatal start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_curso_preparacion start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atencion_parto start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_emer_obstetrica start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atn_puerperio start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atencion_rn start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atn_complicaciones start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_seguimiento_rn start 2;');
        DB::statement('CREATE SEQUENCE "'.$id.'".seq_rias_apn_atn_familias start 2;');

        // Creación del espacio en el Box
        $carpetaBox = $this->crearCarpetasBaseCliente(strval($id));

        if ($carpetaBox['estado']) {
            Clientes::where('cli_pk_id', $id)->update([
                'cli_box_id_cliente' => $carpetaBox['cliente'],
                'cli_box_id_calidad' => $carpetaBox['calidad'],
                'cli_box_id_pamec' => $carpetaBox['pamec'],
                'cli_box_id_rias' => $carpetaBox['rias'],
                'cli_box_id_suh_3100' => $carpetaBox['suh-3100']
            ]);

            return [$id, $infoProceso];
        } else {
            $infoProceso = 'No fue posible crear de forma exitosa la estructura de carpetas en el Box';
        }

        return [$id, $infoProceso];
    }

    public function actualizarCliente(Request $request, $id) {
        $datos = $request->all();

        Clientes::where('cli_pk_id', $id)->update(
            [
                'cli_razon_social' => $datos['cli_razon_social'],
                'cli_rep_legal' => $datos['cli_rep_legal'],
                'cli_email' => $datos['cli_email'],
                'dep_fk_id' => $datos['dep_fk_id'],
                'mun_fk_id' => $datos['mun_fk_id'],
                'cli_direccion' => $datos['cli_direccion'],
                'cli_fecha_inicio' => $datos['cli_fecha_inicio'],
                'cli_fecha_fin' => $datos['cli_fecha_fin'],
                'cli_numero_usuarios' => $datos['cli_numero_usuarios'],
                'cli_mod_suh_3100' => $datos['cli_mod_suh_3100'],
                'cli_mod_aud_calidad' => $datos['cli_mod_aud_calidad'],
                'cli_mod_rias' => $datos['cli_mod_rias'],
                'cli_mod_pamec' => $datos['cli_mod_pamec'],
                'cli_almacenamiento_nube' => $datos['cli_almacenamiento_nube'],
                'cli_activo' => $datos['cli_activo']
            ]
        );
    }

    public function actualizarNombreEntidad(Request $request) {
        $cliente = Auth::user()->cli_fk_id;
        Clientes::where('cli_pk_id', $cliente)->update(['cli_razon_social' => $request->nombre]);
    }

    public function actualizarLogoEntidad(Request $request) {
        $idLogo = null;

        DB::transaction(function() use($request, &$idLogo) {
            $cliente = Auth::user()->cli_fk_id;
            $idLogo = Clientes::where('cli_pk_id', $cliente)->pluck('cli_logo_entidad')[0];

            $file = file_get_contents($request->logo->path());

            if ($idLogo === null) {
                $idLogo = $cliente.Str::random(70);
            }

            Storage::put('public/logos/entidades/'.$idLogo.'.png', $file);
            Clientes::where('cli_pk_id', $cliente)->update(['cli_logo_entidad' => $idLogo]);
        });

        return [$idLogo];
    }

    public function actualizarDobleFactorAutenticacion(Request $request) {
        $cliente = Auth::user()->cli_fk_id;
        Clientes::where('cli_pk_id', $cliente)->update(['cli_doble_factor_auth' => $request->valor]);
    }

    private function crearCarpetasBaseCliente($idCliente) {
        $boxController = new BoxController();
        $token = $boxController->generarToken();
        $estado = ['estado'  => true, 'cliente' => null, 'calidad' => null, 'pamec' => null, 'rias' => null, 'suh-3100' => null];

        if ($token['estado']) {
            // Raiz
            $carpetaRaiz = $boxController->crearFolder($idCliente);

            if ($carpetaRaiz['estado']) {
                $estado['cliente'] = $carpetaRaiz['id'];

                // Calidad
                $carpetaCalidad = $boxController->crearFolder('calidad', $carpetaRaiz['id']);

                if (!$carpetaCalidad['estado']) {
                    $estado = ['estado'  => false];
                } else {
                    $estado['calidad'] = $carpetaCalidad['id'];
                }

                // PAMEC
                $carpetaPamec = $boxController->crearFolder('pamec', $carpetaRaiz['id']);

                if (!$carpetaPamec['estado']) {
                    $estado = ['estado'  => false];
                } else {
                    $estado['pamec'] = $carpetaPamec['id'];
                }

                // RIAS
                $carpetaRias = $boxController->crearFolder('rias', $carpetaRaiz['id']);

                if (!$carpetaRias['estado']) {
                    $estado = ['estado'  => false];
                } else {
                    $estado['rias'] = $carpetaRias['id'];
                }

                // SUH 3100
                $carpetaSuh3100 = $boxController->crearFolder('suh-3100', $carpetaRaiz['id']);

                if (!$carpetaSuh3100['estado']) {
                    $estado = ['estado'  => false];
                } else {
                    $estado['suh-3100'] = $carpetaSuh3100['id'];
                }
            }
        } else {
            $estado = ['estado'  => false];
        }

        return $estado;
    }*/
}
